qui {
noisily {
	/*************************************************/
	/*** Step 1.13. Preliminary analysis		  ****/
	/*************************************************/
	}
	
/* 1.13.1. Figure 1a. */

	/* 1.13.1.1. Generate necessary variables */
	
		gen relative_performance_pre = .
		label var relative_performance_pre "Relative economic performance in the 10th pre-independence year"
		gen relative_performance_post = .
		label var relative_performance_post "Relative economic performance in the 10th post-independence year"
		
		xtset cntrycode year
		
		sum cntrycode
		foreach cntry of numlist 1/`r(max)' {
			foreach spring of numlist 1/2 {
				sum year if independence_years == 0 & cntrycode == `cntry' & spring == `spring' & year >= ${startyear}		
				if r(mean) != . {																							// Only consider NICs (those countries which became independent between 1940-2016, the period for which we have data)
					scalar pre = r(mean) - 10																				// identify 10th pre-independence year for each country
					scalar post = r(mean) + 10																				// identify 10th post-independence year for each country
		
					sum baseline_gdpcap if independence_years > -1 & year == pre [iweight=pop]								// identify population-weighted average per capita GDP level in the world, 10 year prior to this country's declaration of independence
					scalar global_average_pre = r(mean)
					sum baseline_gdpcap if cntrycode == `cntry' & year == pre												// identify per capita GDP level in the NIC itself, 10 year prior to its declaration of independence
					replace relative_performance_pre = (r(mean)-global_average_pre)/global_average_pre*100 if cntrycode == `cntry' & spring == `spring'
		
					sum baseline_gdpcap if independence_years > -1 & year == post [iweight=pop]								// identify population-weighted average per capita GDP level in the world, 10 year after this country's declaration of independence
					scalar global_average_post = r(mean)
					sum baseline_gdpcap if cntrycode == `cntry' & year == post												// identify per capita GDP level in the NIC itself, 10 year after to its declaration of independence
					replace relative_performance_post = (r(mean)-global_average_post)/global_average_post*100 if cntrycode == `cntry' & spring == `spring'			
					}
				}
			}

	/* 1.13.1.2. Plot results (Diff-in-diff) */
			
		twoway 			(scatter relative_performance_post relative_performance_pre, mcolor(gs0) msymbol(0)) || ///
						(line relative_performance_pre relative_performance_pre, lcolor(gs0)) || ///
						(lfit relative_performance_post relative_performance_pre, lcolor(gs8) lpattern(tight_dot)) ///
						if independence_years == 0 & relative_performance_post < 200 & relative_performance_post > -100 & relative_performance_pre < 200  & relative_performance_pre > -100 ///
						, xlab(-100 "-100%" -50 "-50%" 0 "0%" 50 "50%" 100 "100%" 150 "150%" 200 "200%", angle(horizontal))  ylab(-100 "-100%" -50 "-50%" 0 "0%" 50 "50%" 100 "100%" 150 "150%" 200 "200%", angle(horizontal) nogrid) ytitle("10 years after independence", size(large)) xtitle("10 years prior to independence", size(large)) graphregion(color(white)) bgcolor(white) legend(ring(0) position(11) rows(2) order(2 "45° line" 3 "Regression line"))
		cd ..
		cd ".\5. TeX results"
		graph export figure1_a.pdf, replace

	/* 1.13.1.3. Get aggregate estimate */
	
		* Define bootstrap program
		cap program drop bootstrap_discrepancy
		program define bootstrap_discrepancy, rclass
		sum discrepancy if independence_years == 0 [w=popshare]
		return scalar discrepancy = r(mean)
		end
		
		* Bootstrap aggregate discrepancy
		gen discrepancy = relative_performance_post - relative_performance_pre
		noi di "Diff-in-diff estimate:"
		tsset, clear
		noi bootstrap r(discrepancy), reps(500): bootstrap_discrepancy
		xtset cntrycode year
		
	/* 1.13.1. Figure 1b. */

	/* 1.13.1.1. Generate necessary variables */
	
		xtset cntrycode year 
		gen baseline_ggdpcap = (baseline_lgdpcap - L.baseline_lgdpcap)*100
		label var baseline_ggdpcap "Per capita GDP growth (baseline)"
		
		gen avg_growth_NIC = .
		label var baseline_ggdpcap "Per capita GDP growth in NICs (baseline)"
		gen avg_growth_NIC_ub = .
		gen avg_growth_NIC_lb = .
				
		foreach year of numlist -20/20 {
			ci means baseline_ggdpcap if independence_years == `year' & year > ${startyear}
			replace avg_growth_NIC = r(mean) if independence_years == `year' & year > ${startyear}
			}
			
	/* 1.13.1.2. Arrange data */
	
		sort independence_years
		label var avg_growth_NIC "Average per capita GDP growth"
		label var independence_years "Years around a declaration of independence"

	/* 1.13.1.2. Plot results */

		twoway (line avg_growth_NIC independence_years, lcolor(gs0)) if independence_years <= 10 & independence_years >= -10 ///
		, xline(0, lpattern(dot) lcolor(gs8)) graphregion(color(white)) ylab( -1.5 "-1.5%" 0 "0%" 1.5 "1.5%" 3 "3%" 4.5 "4.5%", angle(horizontal))  bgcolor(white) ytitle("Average per capita GDP growth", size(large)) xtitle("Years around a declaration of independence", size(large)) yline(0, lpattern(tight_dot)  lcolor(gs8))
		graph export figure1_b.pdf, replace

	/* 0.13.3. Remove unnecessary variables */
	
	drop relative_* discrepancy baseline_ggdpcap avg_*

* Reroute to directory containing dofiles
cd ..
cd ".\1. Dofiles"
}
